async function getProjects() {
  const base = process.env.NEXT_PUBLIC_API_BASE || "https://app.maharah-hub.com";
  const res = await fetch(`${base}/api/public/projects`, { cache: "no-store" });
  if (!res.ok) return null;
  return res.json();
}

export default async function Projects() {
  const data = await getProjects();
  const items = data?.data?.data || [];

  return (
    <div className="container">
      <a className="btn" href="/">عودة</a>
      <h1>المشاريع</h1>
      <div className="grid">
        {items.length === 0 && <div className="card">لا توجد مشاريع منشورة بعد.</div>}
        {items.map((p: any) => (
          <div key={p.id} className="card">
            <h3 style={{marginTop:0}}>{p.title}</h3>
            <p style={{whiteSpace:"pre-wrap"}}>{p.description || "—"}</p>
            <div className="row">
              {p.budget && <span className="badge">{p.budget} {p.currency}</span>}
              {p.duration_text && <span className="badge">{p.duration_text}</span>}
              <span className="badge">{p.status}</span>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
}
