async function getJobs() {
  const base = process.env.NEXT_PUBLIC_API_BASE || "https://app.maharah-hub.com";
  const res = await fetch(`${base}/api/public/jobs`, { cache: "no-store" });
  if (!res.ok) return null;
  return res.json();
}

export default async function Jobs() {
  const data = await getJobs();
  const items = data?.data?.data || [];

  return (
    <div className="container">
      <a className="btn" href="/">عودة</a>
      <h1>الوظائف</h1>
      <div className="grid">
        {items.length === 0 && <div className="card">لا توجد وظائف بعد (ارفع وظائف من لوحة الشركة ثم انشرها).</div>}
        {items.map((j: any) => (
          <a key={j.id} className="card" href={`/jobs/${j.slug}`}>
            <h3 style={{marginTop:0}}>{j.title}</h3>
            <div className="row">
              {j.location_city && <span className="badge">{j.location_city}</span>}
              <span className="badge">{j.work_type}</span>
              <span className="badge">{j.employment_type}</span>
            </div>
          </a>
        ))}
      </div>
    </div>
  );
}
