async function getFreelancers() {
  const base = process.env.NEXT_PUBLIC_API_BASE || "https://app.maharah-hub.com";
  const res = await fetch(`${base}/api/public/freelancers`, { cache: "no-store" });
  if (!res.ok) return null;
  return res.json();
}

export default async function Freelancers() {
  const data = await getFreelancers();
  const items = data?.data?.data || [];

  return (
    <div className="container">
      <a className="btn" href="/">عودة</a>
      <h1>المستقلين</h1>
      <div className="grid grid3">
        {items.length === 0 && <div className="card">لا يوجد مستقلين بعد.</div>}
        {items.map((f: any) => (
          <div key={f.id} className="card">
            <h3 style={{marginTop:0}}>{f.display_name}</h3>
            <div className="row">
              {Array.isArray(f.skills) && f.skills.slice(0,3).map((s: string) => <span key={s} className="badge">{s}</span>)}
            </div>
            <p>{f.title || ""}</p>
          </div>
        ))}
      </div>
    </div>
  );
}
