<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\PublicJobsController;
use App\Http\Controllers\Api\PublicApplyController;
use App\Http\Controllers\Api\PublicFreelancersController;
use App\Http\Controllers\Api\PublicProjectsController;

Route::prefix('public')->group(function () {
    Route::get('/jobs', [PublicJobsController::class, 'index']);
    Route::get('/jobs/{slug}', [PublicJobsController::class, 'show']);
    Route::post('/jobs/{job}/apply', [PublicApplyController::class, 'apply']);

    Route::get('/freelancers', [PublicFreelancersController::class, 'index']);
    Route::get('/projects', [PublicProjectsController::class, 'index']);
});
