@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
  <div class="mb-6">
    <h1 class="text-2xl font-bold">Maharah Hub — Dashboard</h1>
    <p class="text-sm text-gray-600">MVP overview (ATS + Marketplace)</p>
  </div>

  <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
    <div class="rounded-xl border p-4">
      <div class="text-sm text-gray-600">Active Jobs</div>
      <div class="text-3xl font-semibold">{{ $stats['active_jobs'] }}</div>
    </div>
    <div class="rounded-xl border p-4">
      <div class="text-sm text-gray-600">New Applicants</div>
      <div class="text-3xl font-semibold">{{ $stats['new_applicants'] }}</div>
    </div>
    <div class="rounded-xl border p-4">
      <div class="text-sm text-gray-600">Open Projects</div>
      <div class="text-3xl font-semibold">{{ $stats['open_projects'] }}</div>
    </div>
  </div>

  <div class="mt-8 rounded-xl border p-4">
    <h2 class="text-lg font-semibold mb-2">Next steps</h2>
    <ul class="list-disc pl-6 text-sm text-gray-700 space-y-1">
      <li>Create a tenant (company) and set the user's <code>current_tenant_id</code>.</li>
      <li>Start posting jobs & projects, then connect the public Next.js board to these APIs.</li>
      <li>Enable billing (Moyasar + bank transfer) in Phase 1.1.</li>
    </ul>
  </div>
</div>
@endsection
