<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Tenant;
use App\Models\Plan;
use App\Models\Subscription;

class MvpSeeder extends Seeder
{
    public function run(): void
    {
        // Super admin user
        $adminEmail = 'admin@maharah-hub.local';
        $admin = User::firstOrCreate(
            ['email' => $adminEmail],
            [
                'name' => 'Super Admin',
                'password' => Hash::make('Admin@12345'),
            ]
        );

        // Plans
        $free = Plan::firstOrCreate(
            ['code' => 'free'],
            [
                'name' => 'Free',
                'price_monthly' => 0,
                'price_yearly' => 0,
                'currency' => 'SAR',
                'is_active' => true,
                'is_free' => true,
                'limits' => ['users' => 1, 'active_jobs' => 1, 'ai_cv' => 0],
            ]
        );

        $starter = Plan::firstOrCreate(
            ['code' => 'starter'],
            [
                'name' => 'Starter',
                'price_monthly' => 149,
                'price_yearly' => 1490,
                'currency' => 'SAR',
                'is_active' => true,
                'is_free' => false,
                'limits' => ['users' => 3, 'active_jobs' => 5, 'ai_cv' => 100],
            ]
        );

        $pro = Plan::firstOrCreate(
            ['code' => 'pro'],
            [
                'name' => 'Professional',
                'price_monthly' => 399,
                'price_yearly' => 3990,
                'currency' => 'SAR',
                'is_active' => true,
                'is_free' => false,
                'limits' => ['users' => 10, 'active_jobs' => 999999, 'ai_cv' => 500],
            ]
        );

        $ent = Plan::firstOrCreate(
            ['code' => 'enterprise'],
            [
                'name' => 'Enterprise',
                'price_monthly' => 999,
                'price_yearly' => 9990,
                'currency' => 'SAR',
                'is_active' => true,
                'is_free' => false,
                'limits' => ['users' => 999999, 'active_jobs' => 999999, 'ai_cv' => 999999],
            ]
        );

        // Create demo tenant + subscribe it to Free
        $tenant = Tenant::firstOrCreate(
            ['slug' => 'demo-company'],
            [
                'name' => 'Demo Company',
                'email' => 'hr@demo.local',
                'phone' => '+966500000000',
                'city' => 'Jeddah',
                'country' => 'SA',
                'is_active' => true,
                'public_profile_enabled' => true,
            ]
        );

        $tenant->users()->syncWithoutDetaching([
            $admin->id => ['role' => 'super_admin']
        ]);

        // Set admin current tenant
        $admin->current_tenant_id = $tenant->id;
        $admin->save();

        Subscription::firstOrCreate(
            ['tenant_id' => $tenant->id],
            [
                'plan_id' => $free->id,
                'status' => 'active',
                'starts_at' => now(),
                'ends_at' => null,
                'renews_at' => null,
            ]
        );
    }
}
