<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained('tenants')->cascadeOnDelete();
            $table->foreignId('subscription_id')->nullable()->constrained('subscriptions')->nullOnDelete();
            $table->string('provider')->default('moyasar'); // moyasar/bank
            $table->string('provider_payment_id')->nullable()->index();
            $table->unsignedInteger('amount');
            $table->string('currency')->default('SAR');
            $table->string('status')->default('initiated'); // initiated/paid/failed/refunded
            $table->json('payload')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('payments'); }
};
