<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('bids', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained('projects')->cascadeOnDelete();
            $table->foreignId('freelancer_profile_id')->constrained('freelancer_profiles')->cascadeOnDelete();
            $table->float('amount');
            $table->string('currency')->default('SAR');
            $table->string('delivery_time_text')->nullable();
            $table->text('message')->nullable();
            $table->string('status')->default('submitted'); // submitted/shortlisted/accepted/rejected
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('bids'); }
};
