<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('projects', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained('tenants')->cascadeOnDelete();
            $table->string('title');
            $table->string('slug')->index();
            $table->longText('description')->nullable();
            $table->float('budget')->nullable();
            $table->string('currency')->default('SAR');
            $table->string('duration_text')->nullable();
            $table->string('status')->default('open'); // open/in_review/awarded/closed
            $table->boolean('is_published')->default(false);
            $table->timestamps();
            $table->unique(['tenant_id','slug']);
        });
    }
    public function down(): void { Schema::dropIfExists('projects'); }
};
