<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('applications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained('tenants')->cascadeOnDelete();
            $table->foreignId('job_id')->constrained('jobs')->cascadeOnDelete();
            $table->foreignId('candidate_id')->constrained('candidates')->cascadeOnDelete();
            $table->string('stage')->default('applied');
            $table->string('status')->default('active'); // active/rejected/hired
            $table->float('score')->nullable();
            $table->string('source')->nullable();
            $table->timestamps();
            $table->unique(['job_id','candidate_id']);
        });
    }
    public function down(): void { Schema::dropIfExists('applications'); }
};
