<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('jobs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained('tenants')->cascadeOnDelete();
            $table->string('title');
            $table->string('slug')->index();
            $table->string('department')->nullable();
            $table->string('location_city')->nullable();
            $table->string('location_country')->nullable();
            $table->string('work_type')->default('onsite'); // onsite/remote/hybrid
            $table->string('employment_type')->default('full_time'); // full_time/part_time/contract
            $table->unsignedInteger('min_salary')->nullable();
            $table->unsignedInteger('max_salary')->nullable();
            $table->string('currency')->default('SAR');
            $table->longText('description')->nullable();
            $table->longText('requirements')->nullable();
            $table->boolean('is_published')->default(false);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->unique(['tenant_id','slug']);
        });
    }
    public function down(): void { Schema::dropIfExists('jobs'); }
};
