<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users','current_tenant_id')) {
                $table->unsignedBigInteger('current_tenant_id')->nullable()->after('id');
            }
        });
    }
    public function down(): void {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users','current_tenant_id')) {
                $table->dropColumn('current_tenant_id');
            }
        });
    }
};
