<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Job extends Model
{
    protected $fillable = [
        'tenant_id','title','slug','department','location_city','location_country',
        'work_type','employment_type','min_salary','max_salary','currency',
        'description','requirements','is_published','is_active'
    ];

    protected $casts = [
        'is_published' => 'boolean',
        'is_active' => 'boolean',
        'min_salary' => 'integer',
        'max_salary' => 'integer',
    ];
}
