<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetTenant
{
    public function handle(Request $request, Closure $next): Response
    {
        // For MVP: tenant is selected via header "X-Tenant-ID" (dashboard can set it),
        // or via authenticated user's current_tenant_id.
        $tenantId = $request->header('X-Tenant-ID');

        if (!$tenantId && $request->user()) {
            $tenantId = $request->user()->current_tenant_id;
        }

        if ($tenantId) {
            app()->instance('tenant_id', (int) $tenantId);
        }

        return $next($request);
    }
}
