<?php

namespace App\Http\Controllers\App;

use App\Http\Controllers\Controller;
use App\Models\Job;
use App\Models\Application;
use App\Models\Project;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function __invoke(Request $request)
    {
        $tenantId = app('tenant_id', null);

        $stats = [
            'active_jobs' => $tenantId ? Job::where('tenant_id', $tenantId)->where('is_active', true)->count() : 0,
            'new_applicants' => $tenantId ? Application::where('tenant_id', $tenantId)->where('stage', 'applied')->count() : 0,
            'open_projects' => $tenantId ? Project::where('tenant_id', $tenantId)->whereIn('status', ['open','in_review'])->count() : 0,
        ];

        return view('app.dashboard', compact('stats'));
    }
}
