<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Project;
use Illuminate\Http\Request;

class PublicProjectsController extends Controller
{
    public function index(Request $request)
    {
        $q = Project::query()
            ->where('is_published', true)
            ->whereIn('status', ['open','in_review'])
            ->latest();

        return response()->json(['data' => $q->paginate(12)]);
    }
}
