<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Job;
use Illuminate\Http\Request;

class PublicJobsController extends Controller
{
    public function index(Request $request)
    {
        $q = Job::query()
            ->where('is_published', true)
            ->where('is_active', true);

        if ($request->filled('city')) {
            $q->where('location_city', $request->string('city'));
        }
        if ($request->filled('work_type')) {
            $q->where('work_type', $request->string('work_type'));
        }
        if ($request->filled('employment_type')) {
            $q->where('employment_type', $request->string('employment_type'));
        }

        return response()->json([
            'data' => $q->latest()->paginate(12),
        ]);
    }

    public function show(string $slug)
    {
        $job = Job::where('slug', $slug)
            ->where('is_published', true)
            ->where('is_active', true)
            ->firstOrFail();

        return response()->json(['data' => $job]);
    }
}
