<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\FreelancerProfile;
use Illuminate\Http\Request;

class PublicFreelancersController extends Controller
{
    public function index(Request $request)
    {
        $q = FreelancerProfile::query()
            ->where('is_public', true)
            ->latest();

        if ($request->filled('skill')) {
            $skill = $request->string('skill')->toString();
            $q->whereJsonContains('skills', $skill);
        }

        return response()->json(['data' => $q->paginate(12)]);
    }
}
