<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Application;
use App\Models\Candidate;
use App\Models\Job;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class PublicApplyController extends Controller
{
    public function apply(Request $request, Job $job)
    {
        if (!$job->is_published || !$job->is_active) {
            return response()->json(['message' => 'Job is not available'], 422);
        }

        $validated = $request->validate([
            'email' => ['required','email'],
            'phone' => ['nullable','string','max:50'],
            'first_name' => ['required','string','max:80'],
            'last_name' => ['required','string','max:80'],
            'city' => ['nullable','string','max:80'],
            'country' => ['nullable','string','max:80'],
            'source' => ['nullable','string','max:80'],
        ]);

        $candidate = Candidate::firstOrCreate(
            ['email' => $validated['email']],
            [
                'phone' => $validated['phone'] ?? null,
                'first_name' => $validated['first_name'],
                'last_name' => $validated['last_name'],
                'city' => $validated['city'] ?? null,
                'country' => $validated['country'] ?? null,
            ]
        );

        $exists = Application::where('job_id', $job->id)->where('candidate_id', $candidate->id)->exists();
        if ($exists) {
            return response()->json(['message' => 'Already applied'], 409);
        }

        $app = Application::create([
            'tenant_id' => $job->tenant_id,
            'job_id' => $job->id,
            'candidate_id' => $candidate->id,
            'stage' => 'applied',
            'status' => 'active',
            'source' => $validated['source'] ?? 'public',
            'score' => null,
        ]);

        return response()->json(['data' => $app], 201);
    }
}
