# Maharah Hub (MVP Starter Kit) — Laravel + Next.js (AR/EN, Multi-tenant, ATS + Marketplace + Billing)

This ZIP is a **one-shot upload** package designed for VPS/cPanel deployment.
It includes:
- `install.sh` to bootstrap a fresh Laravel app (via Composer on your server) and apply the included overlay.
- `overlay/` containing your MVP code: migrations, models, middleware, routes, controllers, and basic Blade views.
- `web-frontend/` a Next.js public site starter (AR/EN + RTL) without node_modules (you run npm install on the server).

> Note: vendor/ and node_modules/ are not included to keep the ZIP small. The install script will download dependencies on your server.

## 1) Upload & Extract
Upload this zip to your VPS and extract it in a folder you control, e.g.
`/home/USER/maharah-hub`

## 2) Run Installer
```bash
cd /home/USER/maharah-hub
chmod +x install.sh
./install.sh
```

The installer will:
- Create `app-backend/` (Laravel) using Composer
- Install Breeze + Sanctum (optional but recommended for dashboard + API auth)
- Copy `overlay/` into `app-backend/`
- Create `.env` if missing (you still must set DB credentials)
- Run migrations

## 3) Configure Environment
Edit:
- `app-backend/.env` → DB_* (MariaDB recommended on cPanel)
- `app-backend/.env` → APP_URL=https://app.maharah-hub.com
- Set your Moyasar keys:
  - MOYASAR_SECRET_KEY=
  - MOYASAR_PUBLISHABLE_KEY=
  - MOYASAR_WEBHOOK_SECRET=

## 4) cPanel / Subdomain Document Roots
- `app.maharah-hub.com` → `/home/USER/maharah-hub/app-backend/public`
- `maharah-hub.com` (Next.js) → Node/Passenger/PM2 proxy (see below)

## 5) Next.js (Public site)
```bash
cd /home/USER/maharah-hub/web-frontend
npm install
npm run build
npm run start
```

If you use PM2:
```bash
pm2 start npm --name maharah-web -- start
pm2 save
```

## 6) MVP Accounts / Roles
- Super Admin (platform) is created by seeder: `php artisan db:seed --class=\Database\Seeders\MvpSeeder`
- Company Admin created on tenant creation endpoint (dashboard later).

## 7) API Endpoints (Public)
- GET `/api/public/jobs`
- GET `/api/public/jobs/{slug}`
- POST `/api/public/jobs/{job}/apply`
- GET `/api/public/freelancers`
- GET `/api/public/projects`

## 8) Roadmap
- Phase 2: Escrow (wallet + holds + disputes), messaging, notifications, calendar integrations, AI layer

